/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import cz.insophy.inplan.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;

public class TimeSpan
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final TimeSpan EMPTY = new TimeSpan(Long.MAX_VALUE, Long.MIN_VALUE);
    private static final Comparator<TimeSpan> START_END_COMPARATOR = new Comparator<TimeSpan>(){

        @Override
        public int compare(TimeSpan o1, TimeSpan o2) {
            if (o1.equals(EMPTY) && !o2.equals(EMPTY)) {
                return 1;
            }
            if (o2.equals(EMPTY) && !o1.equals(EMPTY)) {
                return -1;
            }
            int cmp = Longs.compare(o1.getStart(), o2.getStart());
            return cmp == 0 ? Longs.compare(o1.getEnd(), o2.getEnd()) : cmp;
        }
    };
    private final long start;
    private final long end;

    public TimeSpan(long start, long end) {
        if (end < start && (start != Long.MAX_VALUE || end != Long.MIN_VALUE)) {
            throw new IllegalArgumentException("TimeSpan must hold start <= end.");
        }
        this.end = end;
        this.start = start;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        if (this.equals(EMPTY)) {
            return 0L;
        }
        return this.end - this.start;
    }

    public boolean isInside(long time, boolean startInclusive, boolean endInclusive) {
        if (this.equals(EMPTY)) {
            return false;
        }
        return startInclusive && this.start == time || endInclusive && this.end == time || this.start < time && time < this.end;
    }

    public boolean isInside(long time, boolean startInclusive) {
        return this.isInside(time, startInclusive, false);
    }

    public boolean isInside(long time) {
        return this.isInside(time, true, false);
    }

    public boolean isBefore(long time, boolean inclusive) {
        if (this.equals(EMPTY)) {
            return false;
        }
        if (inclusive) {
            return time < this.start;
        }
        return time <= this.start;
    }

    public boolean isAfter(long time, boolean inclusive) {
        if (this.equals(EMPTY)) {
            return false;
        }
        if (inclusive) {
            return time > this.end;
        }
        return time >= this.end;
    }

    public boolean isEmpty() {
        return this.getLength() == 0L;
    }

    public String toString() {
        return String.format("(%s,%s)", this.getStart(), this.getEnd());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public static TimeSpan fromStartEnd(long start, long end) {
        if (start > end) {
            return EMPTY;
        }
        return new TimeSpan(start, end);
    }

    public static TimeSpan union(TimeSpan ts1, TimeSpan ts2) {
        return TimeSpan.fromStartEnd(Math.min(ts1.start, ts2.start), Math.max(ts1.end, ts2.end));
    }

    public static TimeSpan union(Iterable<TimeSpan> timeBounds) {
        long newStart = Long.MAX_VALUE;
        long newEnd = Long.MIN_VALUE;
        for (TimeSpan ts : timeBounds) {
            if (newStart > ts.getStart()) {
                newStart = ts.getStart();
            }
            if (newEnd >= ts.getEnd()) continue;
            newEnd = ts.getEnd();
        }
        return TimeSpan.fromStartEnd(newStart, newEnd);
    }

    public static TimeSpan union(TimeSpan ... spans) {
        return TimeSpan.union(Arrays.asList(spans));
    }

    public static List<TimeSpan> intervalUnion(Iterable<TimeSpan> timeSpans) {
        if (timeSpans == null) {
            return Collections.emptyList();
        }
        ArrayList<TimeSpan> ts = Lists.newArrayList(timeSpans);
        Collections.sort(ts, START_END_COMPARATOR);
        ArrayList<TimeSpan> ts2 = Lists.newArrayList();
        for (TimeSpan t : ts) {
            if (ts2.isEmpty()) {
                ts2.add(t);
                continue;
            }
            if (((TimeSpan)ts2.get(ts2.size() - 1)).getEnd() >= t.getStart()) {
                ts2.add(TimeSpan.union((TimeSpan)ts2.remove(ts2.size() - 1), t));
                continue;
            }
            ts2.add(t);
        }
        return Collections.unmodifiableList(ts2);
    }

    public static List<TimeSpan> inverse(List<TimeSpan> timeSpans, long from, long to) {
        if (timeSpans == null || from >= to) {
            return Collections.emptyList();
        }
        ArrayList<TimeSpan> ts = Lists.newArrayList(timeSpans);
        Collections.sort(ts, START_END_COMPARATOR);
        ImmutableList.Builder ts2 = ImmutableList.builder();
        long start = from;
        for (TimeSpan t : ts) {
            if (start < t.getStart()) {
                ts2.add(TimeSpan.fromStartEnd(start, t.getStart()));
            }
            start = t.getEnd();
        }
        if (start < to) {
            ts2.add(TimeSpan.fromStartEnd(start, to));
        }
        return ts2.build();
    }

    public static List<TimeSpan> intersection(List<TimeSpan> a, List<TimeSpan> b) {
        ListIterator<TimeSpan> aIt = a.listIterator();
        ListIterator<TimeSpan> bIt = b.listIterator();
        ArrayList<TimeSpan> res = Lists.newArrayList();
        TimeSpan tsA = null;
        TimeSpan tsB = null;
        while (aIt.hasNext() || bIt.hasNext()) {
            TimeSpan intersection;
            if (tsA == null) {
                if (!aIt.hasNext()) break;
                tsA = aIt.next();
            }
            if (tsB == null) {
                if (!bIt.hasNext()) break;
                tsB = bIt.next();
            }
            if (!(intersection = TimeSpan.intersection(tsA, tsB)).isEmpty()) {
                res.add(intersection);
            }
            if (tsA.getEnd() < tsB.getEnd()) {
                tsA = null;
                continue;
            }
            tsB = null;
        }
        return res;
    }

    public static TimeSpan intersection(TimeSpan a, TimeSpan b) {
        TimeSpan second;
        TimeSpan first = a.getStart() < b.getStart() ? a : b;
        TimeSpan timeSpan = second = a.getStart() < b.getStart() ? b : a;
        if (first.getEnd() < second.getStart()) {
            return EMPTY;
        }
        return TimeSpan.fromStartEnd(Math.max(first.getStart(), second.getStart()), Math.min(first.getEnd(), second.getEnd()));
    }

    public static List<TimeSpan> difference(List<TimeSpan> a, List<TimeSpan> b) {
        if (b.isEmpty()) {
            return Lists.newArrayList(a);
        }
        LinkedList<TimeSpan> preres = Lists.newLinkedList(a);
        for (TimeSpan tsB : b) {
            LinkedList<TimeSpan> preres2 = Lists.newLinkedList();
            for (TimeSpan tsA : preres) {
                if (tsB.getStart() <= tsA.getStart() && tsA.getStart() < tsB.getEnd()) {
                    preres2.add(TimeSpan.fromStartEnd(tsB.getEnd(), tsA.getEnd()));
                    continue;
                }
                if (tsA.getStart() < tsB.getStart() && tsB.getEnd() < tsA.getEnd()) {
                    preres2.add(TimeSpan.fromStartEnd(tsA.getStart(), tsB.getStart()));
                    preres2.add(TimeSpan.fromStartEnd(tsB.getEnd(), tsA.getEnd()));
                    continue;
                }
                if (tsB.getStart() < tsA.getEnd() && tsA.getEnd() <= tsB.getEnd()) {
                    preres2.add(TimeSpan.fromStartEnd(tsA.getStart(), tsB.getStart()));
                    continue;
                }
                preres2.add(tsA);
            }
            preres = preres2;
        }
        ArrayList<TimeSpan> res = Lists.newArrayListWithCapacity(preres.size());
        for (TimeSpan ts : preres) {
            if (ts.isEmpty()) continue;
            res.add(ts);
        }
        Collections.sort(res, START_END_COMPARATOR);
        return res;
    }

    public static long length(Iterable<TimeSpan> timeSpans) {
        long length = 0L;
        for (TimeSpan timeSpan : timeSpans) {
            length += timeSpan.getLength();
        }
        return length;
    }

    public static <T extends TimeSpan> T find(List<? extends T> spans, long t) {
        int a = 0;
        int b = spans.size() - 1;
        while (a <= b) {
            int c = (a + b) / 2;
            TimeSpan s2 = (TimeSpan)spans.get(c);
            if (s2.getStart() > t) {
                b = c - 1;
                continue;
            }
            if (s2.getStart() == t || s2.getEnd() > t) {
                return (T)s2;
            }
            a = c + 1;
        }
        return null;
    }

    public static <T extends TimeSpan> T findEndInclusive(List<? extends T> spans, long t) {
        int a = 0;
        int b = spans.size() - 1;
        while (a <= b) {
            int c = (a + b) / 2;
            TimeSpan s2 = (TimeSpan)spans.get(c);
            if (s2.getStart() >= t && s2.getEnd() != t) {
                b = c - 1;
                continue;
            }
            if (s2.getEnd() >= t) {
                return (T)s2;
            }
            a = c + 1;
        }
        return null;
    }

    public static void replace(List<TimeSpan> spans, long from, long to, List<TimeSpan> replacement) {
        Preconditions.checkNotNull(spans, "spans");
        Preconditions.checkNotNull(replacement, "replacement");
        Preconditions.checkArgument(from <= to, "swapped span boundaries");
        if (from == to) {
            return;
        }
        if (spans.isEmpty()) {
            spans.addAll(replacement);
            return;
        }
        int a = TimeSpan.pos(spans, from);
        int b = TimeSpan.pos(spans, to);
        boolean touchingFrom = false;
        if (a > 0) {
            TimeSpan prevSpan = spans.get(a - 1);
            if (prevSpan.end > to) {
                spans.set(a - 1, TimeSpan.fromStartEnd(prevSpan.start, from));
                spans.add(a, TimeSpan.fromStartEnd(to, prevSpan.end));
                b = a;
            } else if (prevSpan.end > from) {
                spans.set(a - 1, TimeSpan.fromStartEnd(prevSpan.start, from));
            }
            boolean bl = touchingFrom = spans.get((int)(a - 1)).end == from;
        }
        if (b > 0 && spans.get((int)(b - 1)).end > to) {
            spans.set(b - 1, TimeSpan.fromStartEnd(to, spans.get((int)(b - 1)).end));
            --b;
        }
        boolean touchingTo = b < spans.size() && spans.get((int)b).start == to;
        List<TimeSpan> x = spans.subList(a, b);
        x.clear();
        if (replacement.isEmpty()) {
            return;
        }
        if (touchingFrom && touchingTo && replacement.size() == 1 && from == replacement.get((int)0).start && to == replacement.get((int)0).end) {
            spans.set(a - 1, TimeSpan.fromStartEnd(spans.get((int)(a - 1)).start, spans.get((int)a).end));
            spans.remove(a);
            return;
        }
        if (touchingFrom && replacement.get((int)0).start == from) {
            spans.set(a - 1, TimeSpan.fromStartEnd(spans.get((int)(a - 1)).start, replacement.get((int)0).end));
            replacement = replacement.subList(1, replacement.size());
            if (replacement.isEmpty()) {
                return;
            }
        }
        TimeSpan last = replacement.get(replacement.size() - 1);
        if (touchingTo && last.end == to) {
            spans.set(a, TimeSpan.fromStartEnd(last.start, spans.get((int)a).end));
            replacement = replacement.subList(0, replacement.size() - 1);
        }
        spans.addAll(a, replacement);
    }

    @VisibleForTesting
    protected static int pos(List<TimeSpan> spans, long t) {
        int n = spans.size();
        int a = 0;
        int b = n - 1;
        while (a < b) {
            int c = (a + b) / 2;
            TimeSpan s2 = spans.get(c);
            if (s2.getStart() < t) {
                a = c + 1;
                continue;
            }
            b = c;
        }
        if (a == n - 1 && spans.get((int)a).start < t) {
            a = n;
        }
        return a;
    }

    public static Comparator<TimeSpan> startEndComparator() {
        return START_END_COMPARATOR;
    }

    public static List<Tuple<Integer, TimeSpan>> cardinalityUnion(@Nonnull List<TimeSpan> spans) {
        Preconditions.checkNotNull(spans);
        PriorityQueue<Long> ends = new PriorityQueue<Long>();
        ArrayList<Tuple<Integer, TimeSpan>> res = Lists.newArrayList();
        int c = 0;
        int oldC = 0;
        long t = Long.MIN_VALUE;
        for (TimeSpan span : spans) {
            if (span.isEmpty()) continue;
            long spanStart = span.getStart();
            while (!ends.isEmpty() && (Long)ends.peek() <= spanStart) {
                long end = (Long)ends.poll();
                if (t < end && end < spanStart) {
                    res.add(Tuple.create(c, TimeSpan.fromStartEnd(t, end)));
                    t = end;
                    oldC = c - 1;
                }
                --c;
            }
            ++c;
            if (t < spanStart) {
                if (c != oldC) {
                    if (oldC > 0) {
                        res.add(Tuple.create(oldC, TimeSpan.fromStartEnd(t, spanStart)));
                    }
                    t = spanStart;
                }
                oldC = c;
            }
            ends.add(span.getEnd());
        }
        while (!ends.isEmpty()) {
            long end = (Long)ends.poll();
            if (t < end) {
                res.add(Tuple.create(c, TimeSpan.fromStartEnd(t, end)));
                t = end;
            }
            --c;
        }
        Preconditions.checkState(c == 0, "Did not end with 0 cardinality.");
        return res;
    }

    public Object clone() {
        return new TimeSpan(this.start, this.end);
    }
}

